<?php
include("db.php");
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

// Get selected categories from query parameters
$selectedCategories = isset($_GET['categories']) ? explode(',', $_GET['categories']) : [];

// Base query
$sql = "SELECT 
        p.Product_id, 
        p.Product_name, 
        p.SKU, 
        p.Selling_price,
        p.MRP, 
        p.qty, 
        p.Product_image, 
        p.Variant,
        p.variant_id, 
        p.Discount_percentage,
        p.category,
        s.Seo_title,
        s.Seo_description
        FROM product p
        LEFT JOIN product_seo s ON p.Product_id = s.Product_id 
        WHERE p.Delete_status = 0 AND p.mode = 1";

// Add category filter if categories are selected
if (!empty($selectedCategories)) {
    $categoryIds = array_map(function($cat) use ($conn) {
        return $conn->real_escape_string($cat);
    }, $selectedCategories);
    
    $sql .= " AND p.category IN ('" . implode("','", $categoryIds) . "')";
}

// Default sorting
$sql .= " ORDER BY p.Product_id DESC";

$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    $products = [];
    while ($row = $result->fetch_assoc()) {
        $products[] = [
            'id' => $row['Product_id'],
            'productname' => $row['Product_name'],
            'sku' => $row['SKU'],
            'saleprice' => $row['Selling_price'],
            'mrp' => $row['MRP'],
            'qty' => $row['qty'] ?: '0',
            'productimg' => $row['Product_image'],
            'weight' => $row['Discount_percentage'],
            'variant' => $row['Variant'],
            'category' => $row['category'],
            'seo_title' => $row['Seo_title'],
            'seo_description' => $row['Seo_description']
        ];
    }
    echo json_encode(['status' => 'success', 'data' => $products]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'No products found']);
}

$conn->close();
?>